library(shiny)

ui <- fluidPage(
  
  sliderInput(inputId = 'multiplier', label = 'Simple scale parameter', 
              min = 0, max = 100, value = 50),
  
  plotOutput(outputId = 'p')
  
)

server <- function(input, output){
  
  output$p <- renderPlot({
    hist(rnorm(1000) * input$multiplier, xlab = 'Values', main = 'Example plot')
  });
  
}


shinyApp(ui = ui, server = server, 
         options = list(port = 8080, launch.browser = TRUE))
